<?php

function avada_child_enqueue_styles()
{

    wp_enqueue_style('avada-parent-style', get_template_directory_uri() . '/style.css');
}

add_action('wp_enqueue_scripts', 'avada_child_enqueue_styles');



// TO TASKS
/*
1. Show Errors in case of validation issue
2. Auto Fill post values in case of error
3. Send emails using methods below
4. Integrate into wordpress
5. Test Properly..
*/
define('INFO_EMAIL', 'info@removalscompare.com.au');

#define('API_URL','http://rqportal.com/api/');
define('API_URL', 'https://member.pricescompare.com.au/api/');

if (isset($_POST['request_url'])) {
    $request_url = $_POST['request_url'];
} else {
    $request_url = $_SERVER['HTTP_HOST'] . '' . $_SERVER['REQUEST_URI'];
}
function send_quote_confirmation_email()
{


    $data = array('post' => null);
    $template_path = get_stylesheet_directory() . '/emails/quote_confirmation.php';

    if (file_exists($template_path)) {
        ob_start();
        include $template_path;
        $message = ob_get_clean();
        $headers = array(
            'Content-Type: text/html; charset=UTF-8',
            'From: Quote Request - Removals Compare <noreply@removalscompare.com.au>',
        );
        wp_mail('quotes@removalistquote.com.au', 'Quote Request Received', $message, $headers);
    } else {
        error_log('Template file not found: ' . $template_path);
    }
}
function send_quote_confirmation_email_customer($email, $discount_code)
{



    $data = array('discount_code' => $discount_code);
    $template_path = get_stylesheet_directory() . '/emails/quote_confirmation_customer.php';

    if (file_exists($template_path)) {
        ob_start();

        include $template_path;
        $message = ob_get_clean();
        $headers = array(
            'Content-Type: text/html; charset=UTF-8',
            'From: Quote Request - Removals Compare <noreply@removalscompare.com.au>',
        );
        wp_mail($email, 'Quote Request Received', $message, $headers);
    } else {
        error_log('Template file not found: ' . $template_path);
    }
}


function register_my_session()
{
    if (!session_id()) {
        //echo 'session start called..';

        session_start();
    }
}
add_action('init', 'register_my_session');

$save_quote_errors = array();
if (isset($_POST) &&  count($_POST) > 0 && $_POST['action'] == 'save_quote') {


    if (!session_id()) {
        session_start();
    }
    $categories = array();
    $chunks = array();
    $items = array();
    //  $_POST['customer_email']='developer2@outnet.com.au';
    $post_items = $_POST['item_quantity'];

    for ($i = 0; $i < count($post_items); $i++) {
        if ((int)$post_items[$i] > 0) {
            $item_obj = new stdClass();
            $item_obj->id = $_POST['item_id'][$i];
            $item_obj->category_id = $_POST['category_id'][$i];
            $item_obj->name = $_POST['item_name'][$i];
            $item_obj->cubic = $_POST['item_cubic'][$i];
            $item_obj->quantity = $_POST['item_quantity'][$i];
            $categories[$item_obj->category_id]['items'][0][] = $item_obj;
            $categories[$item_obj->category_id]['name'] = $_POST['category_name'][$i];
        }
    }

    $final_categories = array();
    foreach ($categories as $category) {
        $cat_obj = new stdClass;
        $cat_obj->name = $category['name'];
        $arr_items = array();
        foreach ($category['items'] as $item) {
            $arr_items[] = $item;
        }
        $cat_obj->items = $arr_items;
        $final_categories[] = $cat_obj;
    }

    $input = array();
    $input['bedrooms'] = $_POST['num_bedrooms']; //$data->bedrooms;
    $input['customer_email'] = $_POST['customer_email']; //$entry[21]; //$data->customer_email;
    $input['customer_name'] = $_POST['customer_name']; //$entry[161];//$data->customer_name;
    $input['customer_phone'] = $_POST['customer_phone']; //$data->customer_phone;
    $input['discount_code'] = ''; //$data->discount_code;
    $input['gtm'] = $_POST['request_url']; //$data->gtm;
    $input['moving_date'] = $_POST['moving_date']; //$data->moving_date;
    $input['moving_from']['originalObject'] = array('postcode' => $_POST['from_postcode'], 'suburb' => $_POST['from_suburb']); //$entry[3]//$data->moving_from;
    $input['moving_to']['originalObject'] = array('postcode' => $_POST['to_postcode'], 'suburb' => $_POST['to_suburb']); //$entry[4]; //$data->moving_to;
    $input['moving_type'] = 'removal'; //$data->moving_type;
    $input['notes'] = $_POST['job_details']; //$data->notes;
    $input['packing'] = 'No thanks'; //$data->packing;
    $input['period'] = ''; //$data->period;
    $input['from_lat'] = '27.646920';
    $input['from_lon'] = '-99.553620';
    $input['to_lat'] = '-37.700140';
    $input['to_lon'] = '145.285900';



    $input['categories'] = $final_categories;

    $input = json_encode($input);



    $res_arrTemp = json_decode($input, FALSE);
    $res_arrTemp->categories = $final_categories;
    $quote = $res_arrTemp;


    // $chunks[]=$items;
    // $_POST['customer_email']='dev9@dev.com';


    // $this->session->set_userdata('submit_data', json_encode($obj));
    $url = API_URL . 'quote/removal';
    $ch = curl_init();

    # set the url, number of POST vars, POST data
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $input);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

    $response = curl_exec($ch);

    # close connection
    curl_close($ch);

    $res_arr = json_decode($response);


    if (isset($res_arr->discount_code)) {
        $discount_code = $res_arr->discount_code;
    } else {
        $discount_code = '';
    }

    if ($res_arr->status == 'OK') {
        //$this->_send_quote_email($post);

        // Send to another services
        //  $res_arrTemp = json_decode($this->session->userdata('submit_data'));
        $res_arrTemp = json_decode($input, FALSE);

        $postdata = $input;
        $temp_message = '';
        $other_services = array();

        if (isset($_POST['selectedServices']) && count($_POST['selectedServices'])) {
            $other_services = $_POST['selectedServices'];
            foreach ($_POST['selectedServices'] as $service) {
                $temp_message = $temp_message . ' ' . $service . "<br/>";
            }
        }

        $servies = $other_services;

        //echo var_dump(json_decode($this->session->userdata('submit_data')));
        //$res_arr->notes = $temp_message;
        $res_arrTemp->services = $other_services;




        // call these functions...
        send_quote_confirmation_email();

        send_quote_confirmation_email_customer($_POST['customer_email'], $discount_code);

        post_to_api(json_encode($res_arrTemp), 'additional');
        wp_safe_redirect($_POST['request_url']);
        $_SESSION['success_message'] = 'Quote has been submitted successfully!';

        unset($_SESSION['post_data']);
        exit();
    } else {
        $save_quote_errors = json_decode($response);
        $_SESSION['save_quote_errors'] = $save_quote_errors;

        $_SESSION['post_data'] = $_POST;
        wp_safe_redirect($_POST['request_url']);
        exit();
        //print_r($save_quote_errors);
        // global $wp_session;

        //  $_SESSION['save_quote_errors'] = $save_quote_errors;
        // $_SESSION['post_data'] = $post_data;
        // header('location: /');
        // exit;
        // print_r($response);
        //exit;
        //echo $response;
        //echo var_dump($input);
        //return;
    }
}


$save_5_form_quote_errors = array();
if (isset($_POST) &&  count($_POST) > 0 && $_POST['action'] == 'save_5_form_quote') {
    if (!session_id()) {
        session_start();
    }

    $categories = array();
    $chunks = array();
    $items = array();

    $post_items = $_POST['item_quantity'];

    for ($i = 0; $i < count($post_items); $i++) {
        if ((int)$post_items[$i] > 0) {
            $item_obj = new stdClass();
            $item_obj->id = $_POST['item_id'][$i];
            $item_obj->category_id = $_POST['category_id'][$i];
            $item_obj->name = $_POST['item_name'][$i];
            $item_obj->cubic = $_POST['item_cubic'][$i];
            $item_obj->quantity = $_POST['item_quantity'][$i];
            $categories[$item_obj->category_id]['items'][0][] = $item_obj;
            $categories[$item_obj->category_id]['name'] = $_POST['category_name'][$i];
        }
    }

    $final_categories = array();
    foreach ($categories as $category) {
        $cat_obj = new stdClass;
        $cat_obj->name = $category['name'];
        $arr_items = array();
        foreach ($category['items'] as $item) {
            $arr_items[] = $item;
        }
        $cat_obj->items = $arr_items;
        $final_categories[] = $cat_obj;
    }

    $input = array();

    $input['customer_email'] = $_POST['customer_email']; 
    $input['customer_name'] = $_POST['customer_name']; 
    $input['customer_phone'] = $_POST['customer_phone'];
    $input['discount_code'] = false;
    $input['gtm'] = $_POST['request_url'];
    $input['notes'] = $_POST['job_details'];
    $input['packing'] = 'No thanks';
    $input['from_lat'] = '27.646920';
    $input['from_lon'] = '-99.553620';
    $input['to_lat'] = '-37.700140';
    $input['to_lon'] = '145.285900';

    // $input['pickup_lat'] = '-37.700140';
    // $input['pickup_lon'] = '145.285900';
    // $input['period'] = '';
    // $input['containers'] = '';
    
    $input['categories'] = $final_categories;

    if ($_POST['moving_type'] == 'storage') {

        $input['moving_date'] = $_POST['moving_date'];
        $input['containers'] = $_POST['containers'];
        $input['pickup']['description'] = array('postcode' => $_POST['pickup_postcode'], 'suburb' => $_POST['pickup_suburb']);
        $input['pickup']['image'] = "";
        $input['pickup']['originalObject'] = array('postcode' => $_POST['pickup_postcode'], 'suburb' => $_POST['pickup_suburb']);
        $input['pickup']['title'] = $_POST['pickup'];
        $input['period'] = $_POST['period'];

        $input['moving_type'] = $_POST['moving_type'];

    } elseif ($_POST['moving_type'] == 'international') {

        $input['bedrooms'] = $_POST['num_bedrooms'];
        $input['moving_date'] = $_POST['moving_date'];

        $input['moving_from']['description'] = array('country_id' => $_POST['international_moving_from_country_id'], 'name' => $_POST['international_moving_from']);
        $input['moving_from']['image'] = "";
        $input['moving_from']['originalObject'] = array('country_id' => $_POST['international_moving_from_country_id'], 'name' => $_POST['international_moving_from']);
        $input['moving_from']['title'] = $_POST['international_moving_from'];

        $input['moving_to']['description'] = array('country_id' => $_POST['international_moving_to_country_id'], 'name' => $_POST['international_moving_to']);
        $input['moving_to']['image'] = "";
        $input['moving_to']['originalObject'] = array('country_id' => $_POST['international_moving_to_country_id'], 'name' => $_POST['international_moving_to']);
        $input['moving_to']['title'] = $_POST['international_moving_to'];

        $input['moving_type'] = $_POST['moving_type'];

    } else {

        $input['bedrooms'] = $_POST['num_bedrooms'];
        $input['moving_date'] = $_POST['moving_date'];

        $input['moving_from']['description'] = array('postcode' => $_POST['from_postcode'], 'suburb' => $_POST['from_suburb']);
        $input['moving_from']['image'] = "";
        $input['moving_from']['originalObject'] = array('postcode' => $_POST['from_postcode'], 'suburb' => $_POST['from_suburb']);
        $input['moving_from']['title'] = $_POST['moving_from'];

        $input['moving_to']['description'] = array('postcode' => $_POST['to_postcode'], 'suburb' => $_POST['to_suburb']);
        $input['moving_to']['image'] = "";
        $input['moving_to']['originalObject'] = array('postcode' => $_POST['to_postcode'], 'suburb' => $_POST['to_suburb']);
        $input['moving_to']['title'] = $_POST['moving_to'];

        $input['moving_type'] = $_POST['moving_type'];

    }

    $input = json_encode($input);

    $res_arrTemp = json_decode($input, FALSE);
    $res_arrTemp->categories = $final_categories;

    if ($_POST['moving_type'] == 'storage') {
        $url = API_URL . 'quote/storage';
    } elseif ($_POST['moving_type'] == 'international') {
        $url = API_URL . 'quote/international';
    } else {
        $url = API_URL . 'quote/removal';
    }

    // echo "<pre>";
    // print_r($res_arrTemp);
    // echo "</pre>";

    // exit();
    $ch = curl_init();

    # set the url, number of POST vars, POST data
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $input);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

    $response = curl_exec($ch);

    # close connection
    curl_close($ch);

    $res_arr = json_decode($response);


    if (isset($res_arr->discount_code)) {
        $discount_code = $res_arr->discount_code;
    } else {
        $discount_code = '';
    }

    if ($res_arr->status == 'OK') {

        
        // call these functions...
        send_quote_confirmation_email();
        send_quote_confirmation_email_customer($_POST['customer_email'], $discount_code);

        $res_arrTemp = json_decode($input, FALSE);
        $postdata = $input;
        $temp_message = '';
        $other_services=array();

        if(isset($_POST['selectedServices']) && count($_POST['selectedServices']))
        {
            $other_services=$_POST['selectedServices'];
            foreach($_POST['selectedServices'] as $service)
            {
                $temp_message = $temp_message.' '.$service."<br/>";
            }
        }

        $servies = $other_services;
        $res_arrTemp->services = $other_services;

        post_to_api(json_encode($res_arrTemp), 'additional');

        wp_safe_redirect($_POST['request_url']);
        $_SESSION['success_message'] = 'Quote has been submitted successfully!';

        unset($_SESSION['post_data']);
        exit();
    } else {
        $save_5_form_quote_errors = json_decode($response);
        $_SESSION['save_5_form_quote_errors'] = $save_5_form_quote_errors;
       
        $_SESSION['post_data'] = $_POST;
        wp_safe_redirect($_POST['request_url']);
        exit();
    }
}


function post_to_api($post, $moving_type)
{

    //$this->session->set_userdata('submit_data', serialize($post));
    // $this->session->set_userdata('submit_data', $post);
    $url = API_URL . 'quote/' . $moving_type;
    #$post_string = json_encode($post);
    #echo '<pre>'.print_r($post,true).'</pre>';
    #echo $url;exit;
    # open connection

    $ch = curl_init();

    # set the url, number of POST vars, POST data
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POST, false);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $post);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

    $response = curl_exec($ch);

    # close connection
    curl_close($ch);

    $res_arr = json_decode($response);

    // echo "<pre>";
    // print_r($res_arr);
    // exit;
    // echo 'Final Response...';
    if (isset($res_arr->discount_code)) {
        $discount_code = $res_arr->discount_code;
    } else {
        $discount_code = '';
    }

    if ($res_arr->status == 'OK') {

        //$this->_send_quote_email($post);
        //$this->session->set_userdata('quote_success', true);
        //$this->session->set_userdata('discount_code', $discount_code);
        //$post = json_decode($post, true);
        //$this->_send_quote_confirmation_email();
        //$this->_send_quote_confirmation_email_customer($post['customer_email'], $discount_code);
    }

    // if (isset($post['customer_email']) && $post['customer_email'] != '' &&
    // 	isset($post['customer_name']) && $post['customer_name'] != '' &&
    // 	isset($post['moving_date']) && $post['moving_date'] != '' &&
    // 	isset($post['moving_type']) && $post['moving_type'] != '') {
    // 	$this->_send_quote_email($post);
    // }

    //print_r($response);
    #echo $response;
}


function getInventory()
{
    if (!session_id()) {
        session_start();
    }

    if (isset($_SESSION['inventory'])) {
        // echo 'inventory fetched from session';
        return $_SESSION['inventory'];
    } else {
        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL => 'https://member.pricescompare.com.au/api/inventory',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
        ));

        $response = curl_exec($curl);

        curl_close($curl);
        $data = json_decode($response, true);
        $_SESSION['inventory'] = $data;
        return $data;
    }
}
function enqueue_custom_scripts()
{
    // Enqueue your script
    wp_enqueue_script('form-js', get_stylesheet_directory_uri() . '/js/form.js', array('jquery'), '1.0', true);
    wp_enqueue_script('show-5-form-js', get_stylesheet_directory_uri() . '/js/show-5-form.js', array('jquery'), '1.0', true);
}
add_action('wp_enqueue_scripts', 'enqueue_custom_scripts');

add_shortcode('show_quote_form', 'show_quote_form');

function show_quote_form()
{
    if (!session_id()) {
        //echo 'session start called..';
        session_start();
    }
    // session_start();
    ob_start();
    include __DIR__ . '/quote_form_html.php';
    $content = ob_get_clean();

    // Return the content
    return $content;
    // return include_once(__DIR__.'/quote_form_html.php');
    //echo file_get_contents(__DIR__.'/quote_form_html.php');
}



add_shortcode('show_5_quote_form', 'show_5_quote_form');

function show_5_quote_form()
{
    if (!session_id()) {
        //echo 'session start called..';
        session_start();
    }
    // session_start();
    ob_start();
    include __DIR__ . '/show_5_quote_form.php';
    $content = ob_get_clean();

    // Return the content
    return $content;
    // return include_once(__DIR__.'/quote_form_html.php');
    //echo file_get_contents(__DIR__.'/quote_form_html.php');
}

add_shortcode('show_quote_cities_title', 'show_quote_cities_title');

function show_quote_cities_title()
{
    // Outside the loop
    $post_id = get_queried_object_id(); // Get the ID of the current queried object (page/post)
    $page_title = get_the_title($post_id); // Get the title of the current queried page/post
    return $page_title;
}
add_shortcode('show_quote_cities_links', 'show_quote_cities_links');

function show_quote_cities_links()
{
    // Assuming your custom post type is named 'your_custom_post_type'
    $args = array(
        'post_type' => 'removalist-quotes', // Specify your custom post type slug here
        'posts_per_page' => -1, // Retrieve all posts
    );

    $custom_query = new WP_Query($args);
    $output = '<style>.quote_cities_links p {
        width: 33%;
        font-weight: 600;
        margin-bottom: 0px;
    }.quote_cities_links {
        display: flex;
        flex-wrap: wrap;
        justify-content: space-between;
    }</style>';
    if ($custom_query->have_posts()) {
        $output .= '<div class="quote_cities_links">';
        while ($custom_query->have_posts()) {
            $custom_query->the_post();

            $output .= '<p><a href="' . get_the_permalink() . '">' . get_the_title() . '</a></p>';
        }
        $output .= '</div>';
        wp_reset_postdata(); // Reset the query
    }
    return $output;
}




add_shortcode('add_supplier_form', 'add_supplier_form');

function add_supplier_form()
{
    if (!session_id()) {
        //echo 'session start called..';
        session_start();
    }
    // session_start();
    ob_start();
    include __DIR__ . '/add_supplier_form.php';
    $content = ob_get_clean();

    // Return the content
    return $content;
}

if (isset($_POST) && !empty($_POST['action']) && $_POST['action'] == 'getArea') {
    getArea();
}
function getArea()
{
    $code = $_POST['value'];
    $curl = curl_init();

    curl_setopt_array($curl, array(
        CURLOPT_URL => 'https://member.pricescompare.com.au/api/postcode/' . urlencode($code),
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'GET',
    ));

    $response = curl_exec($curl);

    curl_close($curl);

    $response = json_decode($response, true);

    $result = ['success' => true, 'data' => $response];
    echo  json_encode($result);
    exit;
}

if (isset($_POST) && !empty($_POST['action']) && $_POST['action'] == 'getCountry') {
    getCountry();
}
function getCountry()
{
    $code = $_POST['value'];
    $curl = curl_init();

    curl_setopt_array($curl, array(
        CURLOPT_URL => 'https://member.pricescompare.com.au/api/country/' . urlencode($code),
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'GET',
    ));

    $response = curl_exec($curl);

    curl_close($curl);

    $response = json_decode($response, true);

    $result = ['success' => true, 'data' => $response];
    echo  json_encode($result);
    exit;
}

// Register Custom Post Type
function create_removal_city_post_type()
{
    $labels = array(
        'name'                  => _x('Removal Cities', 'Post Type General Name', 'text_domain'),
        'singular_name'         => _x('Removal City', 'Post Type Singular Name', 'text_domain'),
        'menu_name'             => __('Removal Cities', 'text_domain'),
        'name_admin_bar'        => __('Removal City', 'text_domain'),
        'archives'              => __('Removal City Archives', 'text_domain'),
        'attributes'            => __('Removal City Attributes', 'text_domain'),
        'parent_item_colon'     => __('Parent Removal City:', 'text_domain'),
        'all_items'             => __('All Removal Cities', 'text_domain'),
        'add_new_item'          => __('Add New Removal City', 'text_domain'),
        'add_new'               => __('Add New', 'text_domain'),
        'new_item'              => __('New Removal City', 'text_domain'),
        'edit_item'             => __('Edit Removal City', 'text_domain'),
        'update_item'           => __('Update Removal City', 'text_domain'),
        'view_item'             => __('View Removal City', 'text_domain'),
        'view_items'            => __('View Removal Cities', 'text_domain'),
        'search_items'          => __('Search Removal City', 'text_domain'),
        'not_found'             => __('Not found', 'text_domain'),
        'not_found_in_trash'    => __('Not found in Trash', 'text_domain'),
        'featured_image'        => __('Featured Image', 'text_domain'),
        'set_featured_image'    => __('Set featured image', 'text_domain'),
        'remove_featured_image' => __('Remove featured image', 'text_domain'),
        'use_featured_image'    => __('Use as featured image', 'text_domain'),
        'insert_into_item'      => __('Insert into Removal City', 'text_domain'),
        'uploaded_to_this_item' => __('Uploaded to this Removal City', 'text_domain'),
        'items_list'            => __('Removal Cities list', 'text_domain'),
        'items_list_navigation' => __('Removal Cities list navigation', 'text_domain'),
        'filter_items_list'     => __('Filter Removal Cities list', 'text_domain'),
    );
    $args = array(
        'label'                 => __('Removal City', 'text_domain'),
        'description'           => __('Post Type Description', 'text_domain'),
        'labels'                => $labels,
        'supports'              => array('title', 'editor', 'thumbnail', 'excerpt'),
        'hierarchical'          => false,
        'public'                => true,
        'show_ui'               => true,
        'show_in_menu'          => true,
        'menu_position'         => 5,
        'menu_icon'             => 'dashicons-location-alt', // Customize the menu icon if needed
        'show_in_admin_bar'     => true,
        'show_in_nav_menus'     => true,
        'can_export'            => true,
        'has_archive'           => false, // Disables the archive page
        'exclude_from_search'   => false,
        'publicly_queryable'    => true,
        'capability_type'       => 'post',
    );
    register_post_type('removalist-quotes', $args);
}
add_action('init', 'create_removal_city_post_type', 0);

$save_supplier_errors = array();
if (isset($_POST) && count($_POST) > 0 && $_POST['action'] == 'save_supplier') {
    if (!session_id()) {
        session_start();
    }
    if (isset($_POST['g-recaptcha-response'])) {
        $recaptcha_secret = '6LcfONopAAAAABvVJR93jSf8avooypTd5gkNcDaZ';
        $recaptcha_response = $_POST['g-recaptcha-response'];

        $url = 'https://www.google.com/recaptcha/api/siteverify';
        $data = array(
            'secret' => $recaptcha_secret,
            'response' => $recaptcha_response
        );

        $options = array(
            'http' => array(
                'method' => 'POST',
                'content' => http_build_query($data)
            )
        );

        $context  = stream_context_create($options);
        $verify = file_get_contents($url, false, $context);
        $captcha_success = json_decode($verify);

        $input = array();
        $input['name'] = $_POST['name'];
        $input['business'] = $_POST['business'];
        $input['company'] = $_POST['company'];
        $input['abn_acn'] = $_POST['abn_acn'];
        $input['address'] = $_POST['address'];
        $input['suburb'] = $_POST['suburb'];
        $input['state'] = $_POST['state'];
        $input['postcode'] = $_POST['postcode'];
        $input['phone'] = $_POST['phone'];
        $input['email'] = $_POST['email'];
        $input['website'] = $_POST['website'];
        $input['description'] = $_POST['description'];

        // Convert $input array to JSON format
        $input_json = json_encode($input);

        // Initialize input errors array
        $input_errors_array = array();

        // Loop through input fields to check for required fields
        foreach ($input as $key => $value) {
            if ($value === null || $value === '') {
                // If field is empty, add error message to errors array
                $save_supplier_errors['message'][] = "$key Field is Required";
            }
        }

        if ($captcha_success->success && empty($save_supplier_errors['message'])) {

            $curl = curl_init();

            curl_setopt_array(
                $curl,
                array(
                    CURLOPT_URL => 'https://member.pricescompare.com.au/api/supplier',
                    CURLOPT_RETURNTRANSFER => true,
                    CURLOPT_ENCODING => '',
                    CURLOPT_MAXREDIRS => 10,
                    CURLOPT_TIMEOUT => 0,
                    CURLOPT_FOLLOWLOCATION => true,
                    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                    CURLOPT_CUSTOMREQUEST => 'POST',
                    CURLOPT_POSTFIELDS => $input_json,
                    CURLOPT_HTTPHEADER => array(
                        'Content-Type: application/json'
                    ),
                )
            );

            $response = curl_exec($curl);
            $response = json_decode($response);

            if (isset($response) && $response->status == 'OK') {
                $_SESSION['success_message'] = 'Supplier added successfully!';
                unset($_SESSION['supplier_post_data']);
                wp_safe_redirect($_POST['request_url']);
                exit();
            } else {
                $save_supplier_errors = $response;
                $_SESSION['save_supplier_errors'] = $save_supplier_errors;
                $_SESSION['supplier_post_data'] = $_POST;
                wp_safe_redirect($_POST['request_url']);
                exit();
            }
            curl_close($curl);
        } else {
            $save_supplier_errors['message'][] = "Fill reCAPTCHA Field and all required fields.";
            $save_supplier_errors = (object) $save_supplier_errors;
            $_SESSION['save_supplier_errors'] = $save_supplier_errors;
            $_SESSION['supplier_post_data'] = $_POST;
            wp_safe_redirect($_POST['request_url']);
            exit();
        }
    } else {
        $save_supplier_errors['message'][] = "reCAPTCHA Field is Required";
        $save_supplier_errors = (object) $save_supplier_errors;
        $_SESSION['save_supplier_errors'] = $save_supplier_errors;
        $_SESSION['supplier_post_data'] = $_POST;
        wp_safe_redirect($_POST['request_url']);
        exit();
    }
}

//get_custom_testimonials();

add_shortcode('get_custom_testimonials', 'get_custom_testimonials');
function get_custom_testimonials()
{
    global $wpdb;

    $sql = "select * from testimonials limit 20";
    $testimonials = $wpdb->get_results($sql, ARRAY_A);


    $sql = "select * from testimonial_company limit 20";
    $testimonials_companies = $wpdb->get_results($sql, ARRAY_A);

    $sql = "select * from names limit 20";
    $testimonials_names = $wpdb->get_results($sql, ARRAY_A);

    $sql = "select * from city order by id asc";
    $cities = $wpdb->get_results($sql, ARRAY_A);

    $city = $cities;
    $fromCity = 'Sydney';
    $from = 'Sydney';

    $fromCity = str_replace("-", "&#8194;", trim($from));
    $fromCity = str_replace("%20", " ", $fromCity);

    // $keyword = str_replace("%20"," ",$keyword);

    $post_codes = search($fromCity);


    $from_postcode = $post_codes;

    $to_postcode = [];
    $marks = [];
    foreach ($post_codes as $pc) {
        if (!in_array(substr($pc['postcode'], 0, 2), $marks)) {
            array_push($marks, substr($pc['postcode'], 0, 2));
            $post_code = searchPC(substr($pc['postcode'], 0, 2));
            if (count($post_code) > 0) {
                array_push($to_postcode, ...$post_code);
            }
        }
    }



    $list_date = [];

    for ($i = 0; $i < 20; $i++) {
        array_push($list_date, (randomDate()));
    }


    $list_job = ['interstate removalist', 'local removalist', 'office removal', 'piano removal', 'fragile item transport'];

    $final_array = array();
    for ($i = 0; $i < 20; $i++) {
        $from_index = rand(0, count($from_postcode) - 1);
        $from_pc = ucwords(strtolower($from_postcode[$from_index]['suburb'])) . " " . $from_postcode[$from_index]['state'];
        $to_pc = $from_pc;
        $final_array[$i]['from_pc'] = $from_pc;
        $final_array[$i]['to_pc'] = $to_pc;

        while ($to_pc == $from_pc) {
            $from_index = rand(0, count($to_postcode) - 1);
            $to_pc = ucwords(strtolower($to_postcode[$from_index]['suburb'])) . " " . $to_postcode[$from_index]['state'];
        }

        $final_array[$i]['from_pc'] = $from_pc;
        $final_array[$i]['to_pc'] = $to_pc;
        $final_array[$i]['name'] = $testimonials_names[$i]['Name'];
        $final_array[$i]['job'] = $list_job[rand(0, 4)];
        $final_array[$i]['date'] = $list_date[$i];
        $final_array[$i]['num_quotes'] = rand(3, 4);
        $final_array[$i]['review_content'] = $testimonials[$i]['Content'];
    }
    // echo '<pre>';
    // print_r($final_array);
    // echo '</pre>';

    $output = "<style>
    
    .color-orange{
        color:#ed4a1c;
    }
    .grey-line {
        border-bottom: 2px solid #e5e7eb;
        display: block;
        margin: 20px 0px;
    }
    .review-box-inner p {
        font-size: 16px;
        font-family: 'Montserrat' !important;
        line-height: 27px;
        font-weight: 500;
        color: #333333;
        margin: 0px;
    }
    .review-box {
        display: flex;
        flex-wrap: wrap;
        gap: 20px;
    }
    .review-box-inner-col {
        display: flex;
        flex-direction: column;
        width: calc(25% - 20px);
        gap: 20px;
    }
    @media only screen and (max-width:768px){
        .review-box-inner-col {
            width: 100% !important;
        }
    }
    .review-box-inner {
        display: flex;
        flex-direction: column;
        border: 4px solid #0f1f34;
        padding: 15px;
    }
    .pt-6 {
        padding-top: 10px;
        color: #ed4a1c;
    }

    </style>";

    // Initialize variables
    $for_box = 1;
    $output .= "<div class='review-box'>";

    // Loop through each item in the final array
    foreach ($final_array as $item) {
        // Open a new column container every 5 reviews
        if ($for_box % 5 == 1) {
            $output .= "<div class='review-box-inner-col'>";
        }
        
        // Start a new review box
        $output .= "<div class='review-box-inner'>";
        $output .= "<p><strong class='color-orange'>" . htmlspecialchars($item['name'], ENT_QUOTES) . "</strong> needed a local removalist job on " . htmlspecialchars($item['date'], ENT_QUOTES) . " moving from <strong>" . htmlspecialchars($item['from_pc'], ENT_QUOTES) . "</strong> to <strong>" . htmlspecialchars($item['to_pc'], ENT_QUOTES) . "</strong>. " . htmlspecialchars($item['name'], ENT_QUOTES) . " received <strong>" . htmlspecialchars($item['num_quotes'], ENT_QUOTES) . " quotes</strong></p><span class='grey-line'></span> <p><strong class='color-orange'>" . htmlspecialchars($item['name'], ENT_QUOTES) . "’s Review</strong></p><p>" . htmlspecialchars($item['review_content'], ENT_QUOTES) . "</p>";
        $output .= '<div class="pt-6">
            <i class="fas fa-star" aria-hidden="true"></i>
            <i class="fas fa-star" aria-hidden="true"></i>
            <i class="fas fa-star" aria-hidden="true"></i>
            <i class="fas fa-star" aria-hidden="true"></i>
            <i class="fas fa-star" aria-hidden="true"></i>
        </div>';
        $output .= "</div>";

        // Close the column container every 5 reviews
        if ($for_box % 5 == 0 || $for_box == count($final_array)) {
            $output .= "</div>";
        }

        // Increment box counter
        $for_box++;
    }

    $output .= "</div>";

    // Return the output
    return $output;

}

function search($keyword)
{
    global $wpdb;
    $sql = "SELECT * FROM `postcodes` WHERE `postcode` LIKE '%$keyword%'
    OR suburb LIKE '%$keyword%' ";
    $postcodes = $wpdb->get_results($sql, ARRAY_A);
    return $postcodes;
}
function searchPC($keyword)
{
    global $wpdb;
    $sql = "SELECT * FROM `postcodes` WHERE `postcode` LIKE '$keyword%' ";
    $postcodes = $wpdb->get_results($sql, ARRAY_A);
    return $postcodes;
}
function randomDate()
{
    // Convert to timetamps
    $min = strtotime("3 October 2015");
    $max = strtotime("now");

    // Generate random number using above bounds
    $val = rand($min, $max);

    // Convert back to desired date format
    return date('d M', $val);
}
