<?php 
session_start();

if(isset($_POST['request_url']))
{
    $request_url=$_POST['request_url'];
}
else
{
    $request_url = site_url().''.$_SERVER['REQUEST_URI'];
}
if(isset($_SESSION['save_supplier_errors']))
{
    $save_supplier_errors = $_SESSION['save_supplier_errors'];
    unset($_SESSION['save_supplier_errors']);
}
if(isset($_SESSION['supplier_post_data']))
{
    $supplier_post_data = $_SESSION['supplier_post_data'];
    unset($_SESSION['supplier_post_data']);
}
    
?>
<style>
    @media only screen and (max-width: 575px) {
        #supplier_form .inputPad {
            width: 100% !important;
        }
    }
#supplier_form .formWrapper {
    width: 100%;
    display: flex;
    flex-wrap: wrap;
    gap: 20px;
}
#supplier_form .inputPad {
    width: calc(50% - 10px);
}
#supplier_form input, #supplier_form textarea {
    width: 100%;
    border: 2px solid #0f1f34;
    border-radius: 30px;
    font-family: 'Montserrat', sans-serif;
    font-size: 16px;
    padding: 10px 10px 10px 20px;
    box-sizing: border-box;
    color: black !important;
    font-weight: 500;
    line-height: 24px;
}
#supplier_form textarea{
    border-radius: 20px !important;
}
.inputPad.width100, .textArea.width100, .sendButton.width100 {
    width: 100% !important;
}
#supplier-add {
    background: #f2610d !important;
    color: #FFF;
    font-family: 'Montserrat', sans-serif;
    font-size: 20px;
    border: none;
    border-radius: 50px;
    padding: 12px 25px 12px 25px;
    font-weight: 700;
    transition: all .3s ease-in-out;
    cursor: pointer;
}
.error-box .error {
    background: #ff00001c;
    color: black;
    padding: 0px 10px;
    font-size: 13px;
    border: 2px solid red;
    border-radius: 5px;
    text-transform: capitalize;
}
.error-box {
    display: flex;
    flex-wrap: wrap;
    gap: 10px;
    margin-bottom: 20px;
    background: #f3f3f3;
    padding: 10px;
    border-radius: 10px;
    justify-content: flex-start;
}

.success-box .success {
    background: #0cbb001c;
    color: black;
    padding: 0px 10px;
    font-size: 13px;
    border: 2px solid #0cbb00;
    border-radius: 5px;
    text-transform: capitalize;
}
.success-box {
    display: flex;
    flex-wrap: wrap;
    gap: 10px;
    margin-bottom: 20px;
    background: #f3f3f3;
    padding: 10px;
    border-radius: 10px;
    justify-content: flex-start;
}

</style>
<script src="https://www.google.com/recaptcha/api.js" async defer></script>
<form method="post" id="supplier_form" >
    <input type="hidden" name="action" value='save_supplier' />
    <input type="hidden" name="request_url" value="<?php echo $request_url; ?>" />
    <?php
        if(isset($_SESSION['success_message']))
        {
            echo '<div class="success-box" ><div class="success">'.$_SESSION['success_message'].'</div></div>';
            unset($_SESSION['success_message']);
        }
    ?>

    <?php
        if(isset($save_supplier_errors) && is_object($save_supplier_errors))
        {

            if(isset($save_supplier_errors->message) && is_array($save_supplier_errors->message))
            {
                echo '<div class="error-box" >';
                foreach($save_supplier_errors->message as $message)
                {
                    if(stripos($message,'_lat') || stripos($message,'_lon'))
                    {
                    continue;
                    }
                    echo '<div class="error">'.$message.'</div>';
                }
                echo '</div>';
            }
        }
    ?>

    <div class="formWrapper">
        <div class="inputPad width100">
        <div><input class="standardInput" id="name" name="name"  value="<?php if(!empty($supplier_post_data['name'])){ echo $supplier_post_data['name']; } ?>" placeholder="Contact Name*" autocomplete="off" required></div>
        </div>

        <div class="inputPad">
            <div><input class="standardInput" id="business" name="business" value="<?php if(!empty($supplier_post_data['business'])){ echo $supplier_post_data['business']; } ?>" placeholder="Business Name*" required></div>
        </div>

        <div class="inputPad">
            <div><input class="standardInput" id="company" name="company" value="<?php if(!empty($supplier_post_data['company'])){ echo $supplier_post_data['company']; } ?>" placeholder="Company Name*" required></div>
        </div>

        <div class="inputPad">
            <div><input class="standardInput" id="abn_acn" name="abn_acn" value="<?php if(!empty($supplier_post_data['abn_acn'])){ echo $supplier_post_data['abn_acn']; } ?>"  placeholder="ABN/ACN*" required></div>
        </div>

        <div class="inputPad">
            <div><input class="standardInput" id="address" name="address" value="<?php if(!empty($supplier_post_data['address'])){ echo $supplier_post_data['address']; } ?>" placeholder="Address*" required></div>
        </div>

        <div class="inputPad">
            <div><input class="standardInput" id="suburb" name="suburb" value="<?php if(!empty($supplier_post_data['suburb'])){ echo $supplier_post_data['suburb']; } ?>"  placeholder="Suburb*" required></div>
        </div>

        <div class="inputPad">
            <div><input class="standardInput" id="state" name="state" value="<?php if(!empty($supplier_post_data['state'])){ echo $supplier_post_data['state']; } ?>" placeholder="State*" data-gtm-form-interact-field-id="0" required></div>
        </div>

        <div class="inputPad">
            <div><input class="standardInput" id="postcode" name="postcode" value="<?php if(!empty($supplier_post_data['postcode'])){ echo $supplier_post_data['postcode']; } ?>" placeholder="Postcode*"required></div>
        </div>

        <div class="inputPad">
            <div><input class="standardInput" id="phone" name="phone" value="<?php if(!empty($supplier_post_data['phone'])){ echo $supplier_post_data['phone']; } ?>" placeholder="Phone*" required></div>
        </div>

        <div class="inputPad">
            <div><input class="standardInput" id="email" name="email" value="<?php if(!empty($supplier_post_data['email'])){ echo $supplier_post_data['email']; } ?>" placeholder="Email*" required></div>
        </div>

        <div class="inputPad">
            <div><input class="standardInput" id="website" name="website" value="<?php if(!empty($supplier_post_data['website'])){ echo $supplier_post_data['website']; } ?>" placeholder="Website*" required></div>
        </div>

        <div class="textArea width100">
        <textarea id="description" name="description" rows="4" cols="50" placeholder="Tell us about your business..." required><?php if(!empty($supplier_post_data['description'])){ echo $supplier_post_data['description']; } ?></textarea>
        </div>

        <div class="captcha textArea width100">
        <div class="g-recaptcha" data-sitekey="6LcfONopAAAAAESALiac3FJ0qZPUs7K-4hxTs98v"></div>
        </div>

        <div class="sendButton margDown width100">
        <button type="submit" id="supplier-add" class="standard bigButton">Sign Up</button>
        </div>

    </div>
</form>