<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
<link href="https://fonts.googleapis.com/css2?family=Montserrat:ital,wght@0,100..900;1,100..900&family=Oswald:wght@200..700&family=Poppins:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&family=Rubik:ital,wght@0,300..900;1,300..900&display=swap" rel="stylesheet">

  <style>
 *, ::after, ::before {
    box-sizing: border-box;
    border-width: 0;
    border-style: solid;
    border-color: #e5e7eb;
}
.d-none{
    display:none;
}
body {

    font-family: 'Montserrat', sans-serif !important;
    font-size:14px;
}
.text-black.font-bold {
    font-weight: bold;
    font-size: 16px;
    display: block;
    margin-bottom: 8px;
    margin-top:25px;
    color:black;
}
.relative {
    position: relative;
}
.absolute{
    position: absolute;
}
.ng-scope-main {
    background-color: rgb(234 179 8 / 0.3);
    padding: 3rem;
    border-radius: 0.75rem;
    background: #f97d18;
    max-width: 100%;
}
.rounded-md.bg-white.flex {
    display: flex;
    flex-direction: row;
    background-color: #ededed;
    border-radius: 0.375rem;
}
.p-6 {
    padding: 14px;
    width: 58px;
    height: 58px;
}
.mt-8 {
    margin-top: 16px;
}
.ng-hide {
    display: none;
}
.selectInput {
    padding-top: 19px;
    padding-bottom: 19px;
    padding-left: 1.5rem;
    padding-right: 1.5rem;
    --tw-bg-opacity: 1;
    background-color:#fff;
    border-top-right-radius: 0.375rem;
    border-bottom-right-radius: 0.375rem;
    width: 100%;
    font-family: 'Montserrat', sans-serif;
    font-size: 16px;
    color: black;
    font-weight: 500;
}


.text-white {
    --tw-text-opacity: 1;
    color: rgb(255 255 255 / var(--tw-text-opacity));
}

.btnstyle-1 {
    font-weight: 700 !important;
    font-size: 16px !important;
    padding-top: 17.5px !important;
    color:white !important;
    padding-bottom: 17.5px;
    padding-left: 50px;
    padding-right: 50px;
    --tw-bg-opacity: 1;
    background-color: rgb(23 26 38 / var(--tw-bg-opacity));
    border-radius: 0.375rem !important;
    cursor: pointer;
    margin-top: 2rem;
}
.btnstyle-2 {
    color:white !important;
    font-weight: 700 !important;
    font-size: 16px !important;
    padding-top: 17.5px;
    padding-bottom: 17.5px;
    padding-left: 50px;
    padding-right: 50px;
    --tw-bg-opacity: 1;
    background-color: #f55e27;
    border-radius: 0.375rem !important;
    cursor: pointer;
    /* margin-top: 2rem; */
}
.flex.mt-16 {
    display: flex;
}

svg.h-12.w-12.absolute.right-5.top-5 {
    width: 40px;
    height: 59px;
    padding: 6px;
    top: 0px;
    right: 0px;
    background: #fff;
    border-radius: 10px;
}

textarea.selectInput {
    border-radius: 0.375rem !important;
}


.angucomplete-holder {
    width: 100%;
}
.grid {
    display: flex;
    flex-direction: column;
    font-weight: 500;
    font-size: 14px;
}
.grid-main {
    display: flex;
    flex-direction: row;
    justify-content: space-between;
}
.mg-left
{
    margin-left:1.25rem;
}

.modal-lg {
    width: 900px;
    max-height: 80vh;
    overflow-y: scroll;
    margin: 30px auto;
    position: relative;
    background: #fff;
    box-shadow: 0px 0px 0px 0px #ddd;
}
.modal-header {
    padding: 15px;
    border-bottom: 1px solid #e5e5e5;
    min-height: 16.42857143px;
}
.modal-header .close {
    margin-top: -2px;
}
button.close {
    padding: 0;
    cursor: pointer;
    background: 0 0;
    border: 0;
}
.popup_overlay {
    display: none;
}
.close {
    float: right;
    font-size: 21px;
    font-weight: 700;
    line-height: 1;
    color: #000;
    text-shadow: 0 1px 0 #fff;
    opacity: .2;
    filter: alpha(opacity=20);
}
.modal-title {
    margin: 0;
    line-height: 1.42857143;
    font-size: 22px;
}
.modal-body {
    position: relative;
    padding: 20px;
}
.panel {
    margin-bottom: 20px;
    background-color: #fff;
    border: 1px solid transparent;
    border-radius: 4px;
    -webkit-box-shadow: 0 1px 1px rgba(0,0,0,.05);
    box-shadow: 0 1px 1px rgba(0,0,0,.05);
}
.panel-default {
    border-color: #ddd;
}
.panel-default>.panel-heading {
    color: #333;
    background-color: #f5f5f5;
    border-color: #ddd;
}

.modal-footer {
    margin-top: 15px;
    padding: 19px 20px 20px;
    text-align: right;
    border-top: 1px solid #e5e5e5;
}
footer:before {
    content: " ";
    display: table;
}
.btn-warning {
    color: #fff;
    background-color: #ed9c28;
    border-color: #d58512;
}
.btn {
    display: inline-block;
    margin-bottom: 0;
    font-weight: 400;
    text-align: center;
    vertical-align: middle;
    cursor: pointer;
    background-image: none;
    border: 1px solid transparent;
    white-space: nowrap;
    padding: 6px 12px;
    font-size: 14px;
    line-height: 1.42857143;
    border-radius: 4px;
    -webkit-user-select: none;
    -moz-user-select: none;
    -ms-user-select: none;
    user-select: none;
}
.accordion {
  background-color: #eee;
  color: #444;
  cursor: pointer;
  padding: 18px;
  width: 100%;
  border: none;
  text-align: left;
  outline: none;
  font-size: 15px;
  transition: 0.4s;
}

.accordion.active, .accordion:hover {
    background-color: #e0e0e0;
}

.panel {

  display: none;
  background-color: white;
  overflow: hidden;
}
.accordion:before {
    content: '\02795';
    font-size: 13px;
    color: #e0e0e0 !important;
    float: left;
    margin-left: 5px;
    margin-top: 5px;
}

.accordion.active:before {
  content: "\2796";
}
.md-l
{
    margin-left:10px;
}
.flex-two {
    display: flex;

    background: #f1f1f1;
    padding-top: 8px;
    padding-bottom: 8px;
    flex-wrap: wrap;
}
.input-num-main {
    width: 33.3%;
    padding-left: 25px;
    padding: 5px 20px;
    display: flex;
    justify-content: space-between;
    font-weight: 600;
    align-content: center;
    align-items: center;
}
.mg-rt
{
    margin-right:10px;
    height: 30px;
    border-radius: 3px;
    width: 65px;
}
.input-num {
    height: 30px !important;
    border-radius: 3px !important;
    width: 65px !important;
    padding-left: 10px !important;
}
span.md-l {
    font-size: 24px;
}
.popup_overlay.active {
    display: flex;
    align-content: center;
    justify-content: center;
    align-items: center;
    height: 100vh;
    position: fixed;
    top: 0px;
    left: 0px;
    background: #0000002b;
    width: 100%;
    z-index:9999;
}
.accordian_main_div{
    margin-top:15px
}
.postcode_div {
    height: 200px;
    overflow-x: hidden;
    overflow-y: scroll;
}
.select_div {
    position: absolute;
    width: 100%;
    /* height: 200px; */
    top: 58px;
    background: white;
    z-index: 9999;
    overflow: hidden;
}
.angucomplete-holder {
    width: 100%;
    position: relative;
}
.searching-feild {
    padding: 8px 12px;
}
p.postcode_name:hover {
    background: #1f73b7;
    color:#fff;
}
p.postcode_name {
    margin: 0px;
    padding: 12px;
    font-weight: 600;
}
.no_result_feild {
    padding: 8px 12px;
}
.error
{
    color:#fff;
    padding:0px;
}
#quote_form input, #quote_form textarea, #quote_form select {
    border-radius: unset;
    font-size: 17px;
    color: black;
}
#quote_form{
    color:black;
}
.inventory_heading{
        line-height: 17px;
    font-weight: 400;
    color: #333333;
}
.content{
    border: unset;
}
@media only screen and (max-width: 600px) {
    .ng-scope-main {
            padding: 1rem;
    }
    .fusion-fullwidth.fullwidth-box.fusion-builder-row-3.fusion-flex-container.has-pattern-background.has-mask-background.fusion-parallax-up.top-align.nonhundred-percent-fullwidth.non-hundred-percent-height-scrolling.bg-parallax-parent {
        padding: 30px;
    }
    .input-num-main {
        flex-direction: column;
        padding: 10px 10px;
        font-size: 12px;
        align-items: unset;
    }
}

    </style>
</head>
<body>
    <?php

    if(isset($_POST['request_url']))
    {
        $request_url=$_POST['request_url'];
    }
    else
    {
        $request_url=site_url().''.$_SERVER['REQUEST_URI'];
    }
    if(isset($_SESSION['save_quote_errors']))
    {
        $save_quote_errors=$_SESSION['save_quote_errors'];
        unset($_SESSION['save_quote_errors']);

    }
    if(isset($_SESSION['post_data']))
    {
        $post_data=$_SESSION['post_data'];
        unset($_SESSION['post_data']);
    }

    ?>
    <form method="post" id="quote_form">
        <!-- <input type="hidden" name="action" value='save_quote' /> -->
        <input type="hidden" name="action" value='save_5_form_quote' />
        <input type="hidden" name="request_url" value="<?php echo $request_url ?>" />
    <div class="">
        <div class="ng-scope-main box_1">
            <?php
                if(isset($_SESSION['success_message']))
                {
                    echo '<div class="error">'.$_SESSION['success_message'].'</div>';
                    unset($_SESSION['success_message']);
                }
            ?>
            <div class="ng-scope">
                <label class="text-black font-bold"  style="margin-top: 0px !important;">Move Type</label>
                <div class="rounded-md bg-white flex relative">
                    <img loading="lazy" src="https://d2r62opsq0ux2d.cloudfront.net/images/icon-movetype.svg" class="p-6" alt="">
                    <select name="moving_type" id="moving_type" class="selectInput">
                        <option value="moving_home" <?php if(!empty($post_data['moving_type']) && $post_data['moving_type']=='moving_home') { echo 'selected'; }?>>Local Move</option>
                        <option value="moving_interstate" <?php if(!empty($post_data['moving_type']) && $post_data['moving_type']=='moving_interstatee') { echo 'selected'; }?>>Interstate Move</option>

                    </select>
                    <label for="moving_type">
                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor" class="h-12 w-12 absolute right-5 top-5">
                            <path fill-rule="evenodd" d="M5.23 7.21a.75.75 0 011.06.02L10 11.168l3.71-3.938a.75.75 0 111.08 1.04l-4.25 4.5a.75.75 0 01-1.08 0l-4.25-4.5a.75.75 0 01.02-1.06z" clip-rule="evenodd"></path>
                        </svg>
                    </label>
                </div>
            </div>

            <div class="mt-8 ng-scope" >
                <input name="from_postcode" value="<?php if(!empty($post_data['from_postcode'])){ echo $post_data['from_postcode']; } ?>" id="from_postcode" type="hidden" >
                <input name="from_suburb" value="<?php if(!empty($post_data['from_suburb'])){ echo $post_data['from_suburb']; } ?>" id="from_suburb" type="hidden" >

                <label class="text-black font-bold text-[16px]">Moving From</label>
                <div class="rounded-md bg-white flex">
                    <img loading="lazy" src="https://d2r62opsq0ux2d.cloudfront.net/images/icon-location.svg" class="p-6" alt="">

                    <div class="angucomplete-holder">
                        <input name="moving_from" id="moving_from_value" type="text" value="<?php if(!empty($post_data['moving_from'])){ echo $post_data['moving_from']; }  ?>" placeholder="Enter a post code or suburb…" class="selectInput moving_value">
                        <div id="moving_from_dropdown" class="moving_dropdown  angucomplete-dropdown ng-hide" >
                             <div class="angucomplete-searching ng-binding searching-feild ng-hide">Searching...</div>
                               <div class="angucomplete-searching ng-binding ng-hide no_result_feild">No results found</div>
                      </div>
                    </div>

                </div>
            </div>
            <div class="mt-8 ng-scope">
                <input name="to_postcode" value="<?php if(!empty($post_data['to_postcode'])){ echo $post_data['to_postcode']; } ?>" id="to_postcode" type="hidden" >
                <input name="to_suburb" value="<?php if(!empty($post_data['to_suburb'])){ echo $post_data['to_suburb']; } ?>" id="to_suburb" type="hidden" >

                <label class="text-black font-bold text-[16px]">Moving To</label>
                <div class="rounded-md bg-white flex">
                    <img loading="lazy" src="https://d2r62opsq0ux2d.cloudfront.net/images/icon-location.svg" class="p-6" alt="">
                    <div class="angucomplete-holder" ng-class="{'angucomplete-dropdown-visible': showDropdown}">
                        <input name="moving_to" id="moving_to_value" value="<?php if(!empty($post_data['moving_to'])){ echo $post_data['moving_to']; }  ?>" ng-model="searchStr" ng-disabled="disableInput" type="text" placeholder="Enter a post code or suburb…" ng-focus="onFocusHandler()" class="selectInput moving_value placeholder:text-slate-400 px-10 py-[19px] rounded-tr-md rounded-br-md bg-[#ededed] focus:outline-none focus:ring-0 focus:border-none ng-empty" ng-blur="hideResults($event)" autocapitalize="off" autocorrect="off" autocomplete="off" ng-change="inputChangeHandler(searchStr)">

                            <div id="moving_to_dropdown" class="angucomplete-dropdown ng-hide moving_dropdown " ng-show="showDropdown">
                               <div class="angucomplete-searching ng-binding searching-feild ng-hide" ng-show="searching" ng-bind="textSearching">Searching...</div>
                                   <div class="angucomplete-searching no_result_feild ng-binding ng-hide" ng-show="!searching &amp;&amp; (!results || results.length == 0)" ng-bind="textNoResults">No results found</div>
                            </div>
                    </div>

                </div>
            </div>

            <div class="mt-8 ng-scope">
                <label class="text-black font-bold">Bedrooms</label>
                <div class="rounded-md bg-white flex relative">
                    <img loading="lazy" src="https://d2r62opsq0ux2d.cloudfront.net/images/icon-home3.svg" class="p-6" alt="">
                    <select name="num_bedrooms" id="num_bedrooms" class="selectInput" required="">
                         <option label="1" value="1" <?php if(!empty($post_data['num_bedrooms']) && $post_data['num_bedrooms']=='1') { echo 'selected'; }?>>1</option>
                        <option label="2" value="2" <?php if(!empty($post_data['num_bedrooms']) && $post_data['num_bedrooms']=='2') { echo 'selected'; }?>>2</option>
                        <option label="3" value="3" <?php if(!empty($post_data['num_bedrooms']) && $post_data['num_bedrooms']=='5') { echo 'selected'; }?>>3</option>
                        <option label="4" value="4" <?php if(!empty($post_data['num_bedrooms']) && $post_data['num_bedrooms']=='4') { echo 'selected'; }?>>4</option>
                        <option label="5+" value="5+" <?php if(!empty($post_data['num_bedrooms']) && $post_data['num_bedrooms']=='5+') { echo 'selected'; }?>>5+</option>
                    </select>
                    <label for="i-bedrooms">
                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor" class="h-12 w-12 absolute right-5 top-5">
                            <path fill-rule="evenodd" d="M5.23 7.21a.75.75 0 011.06.02L10 11.168l3.71-3.938a.75.75 0 111.08 1.04l-4.25 4.5a.75.75 0 01-1.08 0l-4.25-4.5a.75.75 0 01.02-1.06z" clip-rule="evenodd"></path>
                        </svg>
                    </label>
                </div>
            </div><!-- end ngIf: quote.moving_type != 'storage' -->
            <div class="mt-8">
                <label class="text-black font-bold text-[16px] ng-binding">Moving Date</label>
                <div class="rounded-md bg-white flex">
                    <img loading="lazy" src="https://d2r62opsq0ux2d.cloudfront.net/images/icon-calendar.svg" class="p-6" alt="">
                    <div class="angucomplete-holder">
                        <input name="moving_date" id="moving_date" value="<?php if(!empty($post_data['moving_date']) ) { echo $post_data['moving_date']; }?>" type="date" class="selectInput">
                    </div>
                </div>
            </div>

        <div class="mt-16">
                <input type="button" value="Next" onclick="changeStep(2)" data-direction="next" class="btnNavigation1 btnstyle-1 text-white" />
            </div>

            <?php
            if(isset($save_quote_errors) && is_object($save_quote_errors))
            {

                if(isset($save_quote_errors->message) && is_array($save_quote_errors->message))
                {
                    foreach($save_quote_errors->message as $message)
                    {
                     if(stripos($message,'_lat') || stripos($message,'_lon'))
                     {
                        continue;
                     }
                     echo '<div class="error">'.$message.'</div>';
                    }
                }
            }
         ?>

        </div>
    </div>

<!-- Section2 form -->
<div class="box_2 rounded-xl p-10 lg:p-20 pt-12 bg-yellow-500/30 d-none">
    <div class="ng-scope-main">
        <div class="">
            <label class="text-black font-bold" style="margin-top: 0px !important;">Job Details</label>
            <textarea name="job_details" rows="10" placeholder="Tell us about your move, and include information like, does the property have stairs, lifts or difficult areas to access." class="selectInput"><?php if(!empty($post_data['job_details'])){echo$post_data['job_details'];}?></textarea>
        </div>
        <div class="mt-8">
            <label class="text-black font-bold">Inventory List</label>
            <div class="inventory_heading">Adding an inventory list will allow the suppliers to provide more accurate quotes.
            </div>
        </div>
        <div class="mt-8">
        <input type="button" value="Add Inventory" onclick="openInventoryModal()" class="btnstyle-2 text-white" />
        </div>

        <div class="mt-16">

        <input type="button" value="Back" onclick="prevStep(1)" class="btnstyle-1 text-white"/>
        <input type="button" value="Next" onclick="changeStep(3)" class="btnstyle-1 text-white mg-left"/>
        </div>
    </div>
</div>



<!-- Section3form -->


<div class="rounded-xl box_3 p-10 lg:p-20 pt-12 bg-yellow-500/30 d-none">
    <div class="ng-scope-main">
        <div class="">
            <label class="text-black font-bold"  style="margin-top: 0px !important;">Your Name</label>
            <div class="rounded-md bg-white flex relative">
                <img src="https://d2r62opsq0ux2d.cloudfront.net/images/icon-person.svg" class="p-6" alt="">
                <input name="customer_name" value="<?php if(!empty($post_data['customer_name'])){echo $post_data['customer_name'];}?>" type="text" id="yourname" placeholder="Please provide your first and last names" class="selectInput p-10 rounded-md bg-[#ededed] focus:outline-none focus:ring-0 focus:border-none ng-pristine ng-untouched ng-valid ng-empty">
            </div>
        </div>
        <div class="mt-8">
            <label class="text-black font-bold text-[16px]">Email Address</label>
            <div class="rounded-md bg-white flex relative">
                <img src="https://d2r62opsq0ux2d.cloudfront.net/images/icon-email.svg" class="p-6" alt="">
                <input type="text" name="customer_email" value="<?php if(!empty($post_data['customer_email']) ) { echo $post_data['customer_email']; }?>" id="email" placeholder="Enter your email address" class="selectInput p-10 rounded-md bg-[#ededed] focus:outline-none focus:ring-0 focus:border-none ng-pristine ng-untouched ng-valid ng-empty">
            </div>
        </div>
        <div class="mt-8">
            <label class="text-black font-bold text-[16px]">Phone Number</label>
            <div class="rounded-md bg-white flex relative">
                <img src="https://d2r62opsq0ux2d.cloudfront.net/images/icon-phone1.svg" class="p-6" alt="">
                <input type="text" name="customer_phone"  value="<?php if(!empty($post_data['customer_phone']) ) { echo $post_data['customer_phone']; }?>" id="phone" placeholder="Enter your phone number" class="selectInput p-10 rounded-md bg-[#ededed] focus:outline-none focus:ring-0 focus:border-none ng-pristine ng-untouched ng-valid ng-empty">
            </div>
        </div>

        <div class="mt-8">
            <label class="text-black font-bold ">Would you also like prices For any of these services?</label>
            <div class="grid-main">
                <div class="grid">
                    <label>
                        <input <?php if(!empty($post_data['selectedServices']) && in_array('Cleaners',$post_data['selectedServices'])){ echo 'checked';} ?> type="checkbox" name="selectedServices[]" value="Cleaners" class="rounded scale-150 mr-5">
                        <span class="">Cleaning Service</span>
                    </label>
                    <label>
                        <input <?php if(!empty($post_data['selectedServices']) && in_array('Storage',$post_data['selectedServices'])){ echo 'checked';} ?> type="checkbox" name="selectedServices[]" value="Storage" class="rounded scale-150 mr-5">
                        <span class="">Storage</span>
                    </label>
                    <label>
                        <input <?php if(!empty($post_data['selectedServices']) && in_array('HandyManServices',$post_data['selectedServices'])){ echo 'checked';} ?> type="checkbox" name="selectedServices[]" value="HandyManServices" class="rounded scale-150 mr-5">
                        <span class="">Gas / Electricity Connection</span>
                    </label>
                    <label>
                        <input <?php if(!empty($post_data['selectedServices']) && in_array('RubbishRemovals',$post_data['selectedServices'])){ echo 'checked';} ?> type="checkbox" name="selectedServices[]" value="RubbishRemovals" class="rounded scale-150 mr-5">
                        <span class="">Rubbish Removals</span>
                    </label>
                </div>
                <div class="grid">
                    <label>
                        <input <?php if(!empty($post_data['selectedServices']) && in_array('CarpetCleaners',$post_data['selectedServices'])){ echo 'checked';} ?> type="checkbox" value="CarpetCleaners" name="selectedServices[]" class="rounded scale-150 mr-5">
                        <span class="">Internet Connection</span>
                    </label>
                    <label>
                        <input <?php if(!empty($post_data['selectedServices']) && in_array('GardenMaintenance',$post_data['selectedServices'])){ echo 'checked';} ?> type="checkbox" value="GardenMaintenance" name="selectedServices[]" class="rounded scale-150 mr-5">
                        <span class="">Garden Maintenance</span>
                    </label>
                    <label>
                        <input <?php if(!empty($post_data['selectedServices']) && in_array('PetTransport',$post_data['selectedServices'])){ echo 'checked';} ?> type="checkbox" value="PetTransport" name="selectedServices[]" class="rounded scale-150 mr-5">
                        <span class="">Locksmiths</span>
                    </label>
                    <label>
                        <input <?php if(!empty($post_data['selectedServices']) && in_array('CarTransport',$post_data['selectedServices'])){ echo 'checked';} ?> type="checkbox" value="CarTransport" name="selectedServices[]" class="rounded scale-150 mr-5">
                        <span class="">Car Transport</span>
                    </label>
                </div>
            </div>
        </div>

        <div class="flex mt-16">
        <input type="button" value="Back"  onclick="prevStep(2)" class="btnstyle-1 text-white" />
        <!-- <button onclick="submit_form();" class="btnstyle-1 text-white mg-left">Submit</button> -->
        <button type="submit" class="btnstyle-1 text-white mg-left">Submit</button>
        </div>
    </div>
</div>



<!-- Dialog box -->
<div id="inventory_modal_container">
<div class="popup_overlay" id="popup_overlay">
    <div class="modal-dialog modal-lg">
        <div class="modal-content" uib-modal-transclude="">
        <div class="modal-header ng-scope">
            <input type="button" value="×"  class="close" onclick="closeInventoryModal()" />
            <h3 class="modal-title">Your Inventory List</h3>
        </div>
        <div class="modal-body ng-scope">
        <?php
        $data=getInventory();
        if( is_array($data) && count($data) > 0){
            $iter=0;
        foreach($data['inventory'] as $d) {

        ?>
        <div class="accordian_main_div">
               <!-- <button class="accordion"> <span class="md-l"><?php echo $d['name']; ?></span></button>
                -->
                <input type="button" class="accordion" value="<?php echo $d['name']; ?>" />
               <div class="panel"><div class="flex-two">
                    <?php


                         if(count($d['items']) > 0 && is_array($d['items'])){
                         foreach($d['items'] as $item){
                            if( !empty( $item['name'])){

                         ?>

                                <div class="input-num-main">
                                    <?php echo $item['name']; ?>
                                    <input type="hidden" name="category_name[]" value="<?php echo $d['name'];?>"  />
                                    <input type="hidden" name="category_id[]" value="<?php echo $item['category_id'];?>"  />
                                    <input type="hidden" name="item_id[]" value="<?php echo $item['id'];?>" />
                                    <input type="hidden" name="item_name[]" value="<?php echo $item['name'];?>" />
                                    <input type="hidden" name="item_cubic[]" value="<?php echo $item['cubic'];?>" />
                                    <input type="number" value="<?php if(!empty($post_data['item_quantity'][$iter])) echo $post_data['item_quantity'][$iter]; ?>" name="item_quantity[]" min="0"  class="input-num qty_field" />
                                </div>
                    <?php
                    $iter++;
                    }

        }
    } ?>

                        </div>
                </div>
                </div>
    <?php
      }

    } ?>
                <div class="modal-footer ng-scope">
                    <button class="btn btn-warning" type="button" onclick="closeInventoryModal()">OK</button>
                    <style>
                        .btn-warning{
                            color: #fff;
                            background-color: #ed9c28;
                            border-color: #d58512;
                        }
                    </style>
                </div>
    </div>
</div>
                    </div> <!-- modal container div -->
</div>
</div>

</form>

<!-- js included from /wp-content/themes/Avada-Child-Theme/js -->
</body>
</html>

