<?php

namespace BitCode\BitFormPro\Core\Update;

use WP_Error;
use BitCode\BitForm\Core\Util\HttpHelper;
use BitCode\BitForm\Core\Util\DateTimeHelper;

final class API
{
    public static function getAPiEndPoint()
    {
        return 'https://wp-api.bitapps.pro';
    }
    public static function getUpdatedInfo()
    {
        $pluginData = new \stdClass();
        $pluginData->updatedAt = date('Y-m-d H:i:s');
        $pluginData->sections['description'] = '';
        $pluginData->sections['changelog'] = '';
        $pluginData->downloadLink = '';
        return $pluginData;
    }

    public static function activateLicense($licenseKey)
    {
        $data = [];
        $data['licenseKey'] = $licenseKey;
        $data['domain'] =  site_url();
        $data['slug'] = 'bitformpro';
        $activateResponse = new \stdClass();
        $activateResponse->status = 'success';
        $activateResponse->expireIn = '2099-12-31';
        self::setKeyData($licenseKey, $activateResponse);
        return true;
    }

    public static function disconnectLicense()
    {
        return true;
    }

    public static function setKeyData($licenseKey, $licData)
    {
        $data['key'] = $licenseKey;
        $data['status'] = $licData->status;
        $data['expireIn'] = $licData->expireIn;
        return update_option('bitformpro_integrate_key_data', $data, 'yes');
    }

    public static function getKey()
    {
        $integrateData = get_option('bitformpro_integrate_key_data');
        $licenseKey = false;
        if (!empty($integrateData) && is_array($integrateData) && $integrateData['status'] === 'success') {
            $licenseKey = $integrateData['key'];
        }
        return $licenseKey;
    }
    public static function removeKeyData()
    {
        return delete_option('bitformpro_integrate_key_data');
    }
}
