<?php

/**
 * Plugin Name: Bit Form
 * Plugin URI:  https://www.bitapps.pro/bit-form
 * Description: Contact Form Builder Plugin: Multi Step Contact Form, Payment Form, Custom Contact Form Plugin by Bit Form
 * Version:     2.10.3
 * Author:      Contact Form Builder - Bit Form
 * Author URI:  https://www.bitapps.pro
 * Text Domain: bit-form
 * Requires PHP: 7.4
 * Domain Path: /languages
 * License: GPLv2 or later
 */

/***
 * If try to direct access  plugin folder it will Exit
 **/
if (!defined('ABSPATH')) {
  exit;
}

// Define most essential constants.
define('BITFORMS_VERSION', '2.10.3');
define('BITFORMS_PLUGIN_MAIN_FILE', __FILE__);

global $bitforms_db_version;
$bitforms_db_version = '2.3';

if (version_compare(PHP_VERSION, '5.6.0', '>=')) {
  $rootVersionFolder = '';
  $olderVersion = get_option('bitforms_version');
  $isMigratedToV2 = get_option('bitforms_migrated_to_v2');
  $isMigratingToV2 = get_option('bitforms_migrating_to_v2');

  if (!$isMigratingToV2 && !$isMigratedToV2) {
    global $wpdb;
    $oldForms = [];
    if ($olderVersion) {
      $oldForms = $wpdb->get_results("SELECT * FROM {$wpdb->prefix}bitforms_form");
    }
    if (count($oldForms) > 0) {
      $rootVersionFolder = 'v1/';
    } else {
      update_option('bitforms_migrated_to_v2', true);
    }
  }
  require_once plugin_dir_path(__FILE__) . $rootVersionFolder . 'includes/loader.php';
}

function bitform_version_migration_notice()
{
  $olderVersion = get_option('bitforms_version');
  $isMigratedToV2 = get_option('bitforms_migrated_to_v2');
  if (!$isMigratedToV2 && $olderVersion) {
    $migrationUrl = admin_url('admin.php?page=bitform');
    $migrationNotice = sprintf(
      esc_html__('Your Bit Form plugin has not been migrated to the latest version (V2). We will cease support for V1 on 01/03/2024 and automatically migrate V1 forms to V2. Please %s to migrate manually. Alternatively, you can disable automatic updates for Bit Form to prevent the automatic migration of Bit Form forms.', 'bit-form'),
      '<a href="' . $migrationUrl . '">' . esc_html__('click here', 'bit-form') . '</a>'
    );
    echo '<div class="notice notice-warning is-dismissible"><p>' . $migrationNotice . '</p></div>';
  }
}

add_action('admin_notices', 'bitform_version_migration_notice');
/**
 * Handles plugin activation.
 *
 * Throws an error if the plugin is activated on an older version than PHP 5.6.
 */
function bitforms_activate_plugin($network_wide)
{
  if (version_compare(PHP_VERSION, '5.6.0', '<')) {
    wp_die(
      esc_html__('bitforms requires PHP version 5.6.', 'bit-form'),
      esc_html__('Error Activating', 'bit-form')
    );
  }

  do_action('bitforms_activation', $network_wide);
}

register_activation_hook(__FILE__, 'bitforms_activate_plugin');

/**
 * Handles plugin deactivation.
 */
function bitforms_deactivate_plugin($network_wide)
{
  if (version_compare(PHP_VERSION, '5.6.0', '<')) {
    return;
  }

  do_action('bitforms_deactivation', $network_wide);
}

register_deactivation_hook(__FILE__, 'bitforms_deactivate_plugin');

/**
 * Handles plugin uninstall.
 *
 * @access private
 */
function bitforms_uninstall_plugin()
{
  if (version_compare(PHP_VERSION, '5.6.0', '<')) {
    return;
  }

  do_action('bitforms_uninstall');
}
register_uninstall_hook(__FILE__, 'bitforms_uninstall_plugin');
