<?php
/*
Template Name: Service Archive
*/


// The Query
$args = array(
    'post_type' => 'service', // Replace 'service' with your custom post type slug
    'posts_per_page' => -1 // Display all posts
);
$service_query = new WP_Query($args);

// The Loop
if ($service_query->have_posts()) :
    while ($service_query->have_posts()) : $service_query->the_post();
        // Display your service content here
        the_title('<h2>', '</h2>');
        the_content();
    endwhile;
else :
    // No posts found
    echo 'No services found.';
endif;

// Reset Post Data
wp_reset_postdata();


?>


<div class="service-cards">
    <?php
    // Custom Query for Services
    $args = array(
        'post_type'      => 'service', // Replace 'service' with your custom post type slug
        'posts_per_page' => -1, // Display all posts
    );
    $service_query = new WP_Query($args);

    // Loop through services
    if ($service_query->have_posts()) :
        while ($service_query->have_posts()) : $service_query->the_post();
    ?>
            <div class="service-card">
                <?php if (has_post_thumbnail()) : ?>
                    <div class="service-thumbnail">
                        <?php the_post_thumbnail('medium'); ?>
                    </div>
                <?php endif; ?>
                <div class="service-content">
                    <h2 class="service-title"><?php the_title(); ?></h2>
                    <div class="service-description">
                        <?php the_content(); ?>
                    </div>
                    <a href="<?php the_permalink(); ?>" class="read-more">Read More</a>
                </div>
            </div>
    <?php
        endwhile;
        wp_reset_postdata(); // Reset Post Data
    else :
        echo 'No services found.';
    endif;
    ?>
</div>

